﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
//#include "gameFunctions/getPathValue.as"
//#include "gameProgram/parseVariablePaths.as"
#include "gameFunctions/nestedEval.as"
	// evalPath
	// resolveContainer
	// getImpliedValue
	
// run()
define_if = function( thisCommand_obj ){
	var TRACE_THIS = false;
	
	var data = thisCommand_obj.data;
	
	// resolve target variable
	// parse any embedded variable paths
	var target_str = nestedEval( data.condition[0], "RAM", "_this" );
	var target = evalPath( target_str, "RAM", "_this" );
	//var target = getImpliedValue( target );		// convert string to appropriate datatype if neccessary
	
	// Handle a blank variable-name the logical way
	if( target_str === '' )		target = undefined;
	
	// resolve value
	var thisValue = getImpliedValue(data.condition[2]);				// skip path detection if it's a non-string value
	
	// parse any embedded variable paths
	thisValue = nestedEval( thisValue, "RAM", "_this" );
	var value = getImpliedValue( thisValue );
	
	
	// test the condition
	var impliedTarget = getImpliedValue( target );
	var conditionIsTrue = false;
	
	switch(data.condition[1])
	{
		case "=":
			if( target == value )					conditionIsTrue = true;
			if( impliedTarget == value )	conditionIsTrue = true;
		break;
		case "!=":
			conditionIsTrue =  (target != value) && (impliedTarget != value);
		break;
		case ">":
			if( isNaN(impliedTarget)==false  &&  isNaN(value)==false )			// both target & value must be numbers
				var conditionIsTrue = (impliedTarget > value);
		break;
		case ">=":
			if( isNaN(impliedTarget)==false  &&  isNaN(value)==false )			// both target & value must be numbers
				var conditionIsTrue = (impliedTarget >= value);
		break;
		case "<":
			if( isNaN(impliedTarget)==false  &&  isNaN(value)==false )			// both target & value must be numbers
				var conditionIsTrue = (impliedTarget < value);
		break;
		case "<=":
			if( isNaN(impliedTarget)==false  &&  isNaN(value)==false )			// both target & value must be numbers
				var conditionIsTrue = (impliedTarget <= value);
		break;
	}// switch:  operator
	
	if(TRACE_SCRIPT || TRACE_THIS){
		trace("if:  "+data.condition[0]+" "+data.condition[1]+" "+data.condition[2]);
		trace("\t ("+target+" "+data.condition[1]+" "+value+")"+"  ("+conditionIsTrue+")");
		mdm.Exception.DebugWindow.trace("if:  "+data.condition[0]+" "+data.condition[1]+" "+data.condition[2]);
		mdm.Exception.DebugWindow.trace("\t ("+target+" "+data.condition[1]+" "+value+")"+"  ("+conditionIsTrue+")");
	}
	
	if(conditionIsTrue  &&  data.length>0)
	{// if:  condition is true  &  there are commands inside the "if" statement
		
		
		var prom = VOW.make();
		// wait for promise:  which resolves when inner script finishes
		thisCommand_obj.script.done = prom.keep;
		// run child event
		thisCommand_obj.script.runEvent(0);
		// wait for script
		return prom;
		
		
	}// if:  condition is true
	else
	{// if:  condition is false
		
		
		// instantly done
		return VOW.make().keep();
		
		
	}// if:  condition is false
}// define_if()